/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.IOException;
import java.io.Reader;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;

public class CharBuffer {
    public static final char EOF = '\uffff';
    public static final int BUF_SIZE = 20480;
    private Reader m_reader;
    private char[] m_buf = new char[20480];
    private int m_curPos;
    private int m_endPos;
    private int m_curLineNumber = 1;
    private int m_curColumnNumber;
    private int m_preLineNumber = 1;
    private int m_preColumnNumber = -1;
    private boolean m_increaseLineNumber = false;
    private boolean m_eof = false;

    public CharBuffer(Reader reader) {
        this.m_reader = reader;
    }

    public char nextChar() throws ParserException {
        if (this.isEmpty() && !this.m_eof) {
            this.fillBuffer();
        }
        if (this.isEmpty()) {
            return '\uffff';
        }
        char c = this.m_buf[this.m_curPos];
        this.m_curPos = this.mod(this.m_curPos + 1, 20480);
        this.m_preLineNumber = this.m_curLineNumber++;
        this.m_preColumnNumber = this.m_curColumnNumber++;
        if (c == '\n') {
            this.m_increaseLineNumber = true;
            return c;
        }
        if (this.m_increaseLineNumber) {
            this.m_curColumnNumber = 1;
            this.m_increaseLineNumber = false;
        }
        return c;
    }

    public char advance(int n) throws ParserException {
        char c = '\uffff';
        int n2 = n;
        while (n2 > 0) {
            c = this.nextChar();
            --n2;
        }
        return c;
    }

    public char getChar(int n) throws ParserException {
        int n2 = this.mod(this.m_curPos + n - 1, 20480);
        if (!this.hasChar(n2)) {
            this.fillBuffer();
        }
        if (this.hasChar(n2)) {
            return this.m_buf[n2];
        }
        return '\uffff';
    }

    public int getCurLineNumber() {
        return this.m_curLineNumber;
    }

    public int getCurColumnNumber() {
        return this.m_curColumnNumber;
    }

    public int getPreLineNumber() {
        return this.m_preLineNumber;
    }

    public int getPreColumnNumber() {
        return this.m_preColumnNumber;
    }

    private boolean hasChar(int n) {
        if (this.m_curPos < this.m_endPos && this.m_curPos <= n && n < this.m_endPos) {
            return true;
        }
        return this.m_curPos > this.m_endPos && (this.m_curPos <= n || n < this.m_endPos);
    }

    private boolean isEmpty() {
        return this.m_curPos == this.m_endPos;
    }

    private boolean isFull() {
        return this.getUnusedBufferSize() == 0;
    }

    private int getUnusedBufferSize() {
        return this.mod(this.m_curPos - this.m_endPos - 1, 20480);
    }

    private void fillBuffer() throws ParserException {
        int n = this.getUnusedBufferSize();
        if (n == 0 || this.m_eof) {
            return;
        }
        if (this.m_curPos <= this.m_endPos) {
            if (this.m_endPos < 20480) {
                if (20480 - this.m_endPos < n) {
                    this.readToBuffer(this.m_endPos, 20480 - this.m_endPos);
                } else {
                    this.readToBuffer(this.m_endPos, n);
                }
            }
            if (!this.m_eof && this.m_curPos > 0) {
                this.readToBuffer(0, this.m_curPos - 1);
                return;
            }
        } else {
            this.readToBuffer(this.m_endPos, n);
        }
    }

    private int readToBuffer(int n, int n2) throws ParserException {
        int n3 = 0;
        try {
            n3 = this.m_reader.read(this.m_buf, n, n2);
        }
        catch (IOException iOException) {
            throw new ParserException(iOException.getMessage());
        }
        if (n3 < n2) {
            this.m_eof = true;
        }
        if (n3 >= 0) {
            this.m_endPos = this.mod(this.m_endPos + n3, 20480);
        }
        return n3;
    }

    private int mod(int n, int n2) {
        if (n < 0) {
            return n + n2;
        }
        if (n >= n2) {
            return n - n2;
        }
        return n;
    }
}

